/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.commandline.launcher.server.port;

import com.aptana.commandline.launcher.CommandlineLauncherPlugin;
import com.aptana.core.logging.IdeLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.datalocation.Location;

public class PortManager {
    private static String dotAptanaFile = null;

    public static int getRunningInstancePort() {
        int port = PortManager.readCurrentPort();
        if (port < 0) {
            return port;
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port, 0, null);
            return -1;
        }
        catch (BindException bindException) {
        }
        catch (IOException e) {
            IdeLog.logInfo((Plugin)CommandlineLauncherPlugin.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e, null);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
        return port;
    }

    public static void doShutdownCleanup() {
        File file;
        if (dotAptanaFile != null && (file = new File(dotAptanaFile)).exists()) {
            file.delete();
        }
    }

    public static void writeCurrentPort(int port) {
        if (dotAptanaFile == null && (dotAptanaFile = PortManager.computeDotAptanaFileName()) == null) {
            return;
        }
        OutputStreamWriter fileWriter = null;
        try {
            try {
                File file = new File(dotAptanaFile);
                fileWriter = new FileWriter(dotAptanaFile);
                PrintWriter pw = new PrintWriter(fileWriter);
                pw.println(String.valueOf(port));
                pw.flush();
                if (file.exists()) {
                    file.deleteOnExit();
                }
            }
            catch (IOException e) {
                IdeLog.logInfo((Plugin)CommandlineLauncherPlugin.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e, null);
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int readCurrentPort() {
        int n;
        if (dotAptanaFile == null && (dotAptanaFile = PortManager.computeDotAptanaFileName()) == null) {
            return -1;
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(dotAptanaFile);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String sPort = bufferedReader.readLine().trim();
            if (sPort.length() == 0) {
                return -1;
            }
            n = Integer.parseInt(sPort);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        catch (FileNotFoundException e) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return -1;
        }
        catch (IOException e) {
            IdeLog.logWarning((Plugin)CommandlineLauncherPlugin.getDefault(), (Throwable)e);
            return -1;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return n;
    }

    private static String computeDotAptanaFileName() {
        URL locationURL;
        File dotAptanaParent = new File(System.getProperty("user.home"));
        Location location = Platform.getInstallLocation();
        if (!(location != null && !location.isReadOnly() || (location = Platform.getConfigurationLocation()) != null && !location.isReadOnly() || (location = Platform.getUserLocation()) != null && !location.isReadOnly())) {
            location = null;
        }
        if (location != null && (locationURL = location.getURL()) != null && "file".equals(locationURL.getProtocol())) {
            try {
                dotAptanaParent = new File(locationURL.toURI());
            }
            catch (URISyntaxException e) {
                dotAptanaParent = new File(locationURL.getPath());
            }
        }
        File computedDotAptanaFile = new File(dotAptanaParent, ".aptana");
        return computedDotAptanaFile.getAbsolutePath();
    }
}

